#!/bin/sh

echo "Running custom entrypoint script..."

# Ensure Node.js is installed (only runs if missing)
if ! command -v node > /dev/null 2>&1; then
  echo "Node.js not found. Installing..."
  apt-get update && apt-get install -y nodejs npm
fi

# Generate the cleanup script
node /config/cleanup.js

# Define cleanup function
run_cleanup() {
  while true; do
    echo "Running cleanup script..."
    /bin/sh /config/run_cleanup.sh
    echo "Cleanup completed. Next run in 12 hours..."
    sleep 43200  # Sleep for 12 hours (43200 seconds)
  done
}

# Start cleanup in the background
run_cleanup &

# Start Graph Node (foreground)
start

