const fs = require('fs')
const path = '/config/config.toml'

try {
  const configData = fs.readFileSync(path, 'utf8')

  const chainRegex = /\[chains\.(\w+)]/g
  let chains = []
  let match

  while ((match = chainRegex.exec(configData)) !== null) {
    chains.push(match[1])
  }

  let scriptContent = `#!/bin/sh\n\n`
  scriptContent += `echo "Starting graph-node cleanup process..."\n`

  chains.forEach((chain) => {
    scriptContent += `graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force ${chain} && \\\n`
  })

  scriptContent += `graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default unused remove && \\\n`
  scriptContent += `graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default unused record\n`

  scriptContent += `echo "Cleanup completed!"\n`

  fs.writeFileSync('/config/run_cleanup.sh', scriptContent)
  fs.chmodSync('/config/run_cleanup.sh', '0755')

  console.log('Cleanup script generated successfully.')
} catch (error) {
  console.error('Error generating cleanup script:', error)
}
