# Node Application

## Introduction

Nodes are the backbone of the Datai Network, and they can be categorized in two different roles:

- **Indexer Nodes**: these nodes are responsible for indexing the projections submitted by the developer. They support the Datai Network by providing infrastructure in exchange for DATAI token rewards. This role is open for anyone.
- **Gateway Nodes**: Gateway nodes are the intermediary between consumers and indexers. They provide the data to the end-users by routing requests to the Indexer nodes and delivering in the correct way, in exchange for DATAI token rewards. This role is not open, it requires previous registration within the Datai Network.

## Setup

### Prerequisites

- [Docker](https://docs.docker.com/get-started/get-docker/)

### Installation

The application can be directly downloaded from the following [link](https://LINK/)

### Node configuration

Once the application is downloaded, some files must be modified to make the node run correctly.

#### .env

This file contains the specific configuration for this specific node. Each user must configure this file.

##### RPC providers

These are the URLs of the different RPC providers for the different networks. Here some examples of different providers being included in the .env file:

MAINNET_PROVIDER=https://eth.llamarpc.com
BASE_PROVIDER=https://base.llamarpc.com

Please take into account that these node provides **must be archive nodes**, otherwise the indexation of the different projections will not be possible.

##### Default provider

This is the URL of the RPC provider where the Datai Network contracts are. For example:

DEFAULT_PROVIDER=base.llamarpc.com

##### Node Owner Address

This is the EVM address owned by the owner of the node. This is the address used for commit the node to the network and for receiving DATAI token rewards. For example:

NODE_OWNER_ADDRESS=0x97A649e33c46DbE1040b784B9497Cf61B1e9F754

##### Base Price per Request

This will be the base price which every request will cost to the end-user. Take into account that when a request is not specific for one single network, the cost will be 3x the base price.

Take into account as well that this amount must reflect all the decimals of the payment currency. For example, if the payment currency is USDT which has 6 decimals, and you want to set a base price of 1 cent, then the amount reflected in this variable should be 10000:

REQUEST_BASE_PRICE=10000

##### Other variables

There are other variables in this .env file which are more technical and related with the database. You can leave the default values:

LOG_LEVEL=debug
DB_MAX_CONNECTIONS=15
UPDATE_MAX_THREADS=100
WATCH_PARALLEL_VERSION=v1

#### common.env

This file is common accross the different node, **there is no need to modify it**. It contains variables related to the database credentials, timeouts, logs and the IPFS.

POSTGRES_HOST=postgres_datai
POSTGRES_USER=graph-node
POSTGRES_PASSWORD=let-me-in
POSTGRES_DB=graph-node

DB_IDLE_CONN_TIMEOUT=30s
DB_TIMEOUT=30s

WATCHERS_MAX_COUNT=100
WATCHERS_CALL_TIMEOUT=20s
WATCHERS_LOG_LEVEL=info
LOG_LEVEL=info

IPFS_HOST=https://datai-ipfs.mymerlin.io

#### config.toml

This file is located in the **graph-node/config** directory and it's critical for the correct indexation of the projections. In this file we must specify which networks we are going to cover, which means we must have the RPC Providers correctly set in the .env file as explained above.

This is how our example looks like:

```
[store]
[store.primary]
connection="postgresql://${POSTGRES_USER}:${POSTGRES_PASSWORD}@${POSTGRES_HOST}:5432/${POSTGRES_DB}?sslmode=prefer"
pool_size = 10
[deployment]
[[deployment.rule]]
indexers = [ "default" ]
[chains]
ingestor = "default"
[chains.mainnet]
shard = "primary"
provider = [
  { label = "mainnet", url = "${MAINNET_PROVIDER}", features = [ "archive", "traces" ] }
]
[chains.base]
shard = "primary"
provider = [
  { label = "base", url = "${BASE_PROVIDER}", features = [ "archive", "traces" ] }
]
```

If, for example, we want to add OPTIMISM network, we should add a piece of cude such as:

```
[chains.optimism]
shard = "primary"
provider = [
  { label = "base", url = "${OPTIMISM_PROVIDER}", features = [ "archive", "traces" ] }
]
```

#### run_cleanup.sh

This file is located in the **graph-node/config** directory and it's key for the automatic database cleanups. If this is not correctly set, the database may be full of unnecessary data. This is our example file:

```
#!/bin/sh

echo "Starting graph-node cleanup process..."
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force mainnet && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force base && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force optimism && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force polygon && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force bsc && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force avalanche && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force zero && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default unused remove && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default unused record
echo "Cleanup completed!"
```

As we can observe, this is covering 7 networks. We must include only the networks that we are covering, specified in our .env and config.toml files. Note that the latest 2 commands must not be modified, only the commands which are network related.

For example, if we plan to cover mainnet and base networks, this is how the file would look like:

```
#!/bin/sh

echo "Starting graph-node cleanup process..."
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force mainnet && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default chain truncate --force base && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default unused remove && \
graphman --config=/config/config.toml --ipfs=ipfs:5001 --node-id=default unused record
echo "Cleanup completed!"
```

### Node Execution

1. Open the terminal in the directory of the application you just downloaded from the link provided above.
2. Pull the latest docker image of the application by running the following command:

```
docker compose pull
```

3. Run the node by executing the following command:

```
docker compose up -d host
```

This is going to create the Docker Container from the Docker Image previously downloaded.

### Node Registration

1. Buy DATAI token for the registration. Tokens must be staked when registering a node.
2. Get the Node Id using the following URL in any browser:

```
http://localhost:9000/node/info
```

3. Open the Datai Network platform usign the following URL:

```
https://datai-network.netlify.app/nodes
```

4. Click the button "**CREATE NODE**" and choose the desired role (Indexer or Gateway).
5. Add the Node Id you got on step 1 and click the button "**REGISTER NODE**".
